(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12352,        480]*)
(*NotebookOutlinePosition[     13192,        507]*)
(*  CellTagsIndexPosition[     13148,        503]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0.771908, 0.399634, 0.262867]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{36, 20}, {0, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->{{100, 4}, {8, 10}},
  TextAlignment->Center,
  LineSpacing->{1, -5},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->48],

Cell[StyleData["Title", "Printout"],
  FontSize->40]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{54, 25}, {2, 30}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->24,
  FontSlant->"Italic",
  FontColor->RGBColor[0.771908, 0.399634, 0.262867]],

Cell[StyleData["Subtitle", "Printout"],
  FontSize->18,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{54, 25}, {30, 10}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellMargins->{{54, 25}, {2, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.771908, 0.399634, 0.262867]],

Cell[StyleData["Section", "Printout"],
  FontSize->12,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{54, 25}, {2, 12}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{2, 12}, {0, 12}},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{54, 25}, {2, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontSlant->"Italic",
  FontColor->RGBColor[0.771908, 0.399634, 0.262867]],

Cell[StyleData["Subsubsection", "Printout"],
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{54, 25}, {6, 6}},
  CellFrameMargins->{{4, 10}, {6, 0}},
  CellFrameLabelMargins->4,
  TextJustification->1,
  LineSpacing->{1.25, 0},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  LineSpacing->{1.5, 0},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{72, 44}, {6, 6}},
  CellFrameMargins->2,
  TextJustification->1,
  LineSpacing->{1, 2},
  CounterIncrements->"SmallText",
  FontSize->10],

Cell[StyleData["SmallText", "Printout"],
  LineSpacing->{1, 3},
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{72, 25}, {8, 12}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{33, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{72, 25}, {12, 4}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{33, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output",
  FontSize->12],

Cell[StyleData["Output", "Printout"],
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{72, 25}, {12, 4}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{33, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique"],

Cell[StyleData["Message", "Printout"],
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{72, 25}, {12, 4}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{33, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{72, 25}, {12, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["Graphics", "Printout"],
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  CellLabelAutoDelete->False,
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic",
  FontColor->RGBColor[0.551492, 0.231144, 0.313466]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{72, 10}, {0, 10}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Printout"],
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{72, 145}, {2, 10}},
  CellHorizontalScrolling->True,
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}]], None}},
  CounterIncrements->"NumberedFigure",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{72, 145}, {2, 10}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}]], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Printout"],
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{72, 10}, {2, 10}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{72, 10}, {2, 10}},
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{54, 10}, {Inherited, 6}},
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  FontSize->9.5]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{481, 312},
WindowMargins->{{12, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 124, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2161, 68, 104, 2, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2302, 75, 35, 0, 30, "Section"],
Cell[2340, 77, 101, 3, 30, "Text"],
Cell[2444, 82, 426, 11, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[2907, 98, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[2970, 102, 336, 9, 75, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3309, 113, 52, 1, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3398, 119, 354, 9, 54, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3755, 130, 82, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3874, 137, 308, 8, 72, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4185, 147, 58, 1, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4280, 153, 346, 9, 46, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4629, 164, 81, 2, 61, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4747, 171, 318, 8, 43, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5068, 181, 57, 1, 40, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5162, 187, 253, 6, 43, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[5418, 195, 86, 2, 39, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5553, 203, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[5617, 207, 204, 6, 40, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[5824, 215, 76, 2, 39, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5937, 222, 217, 7, 47, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[6157, 231, 78, 2, 40, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6284, 239, 42, 0, 30, "Section"],
Cell[6329, 241, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[6602, 250, 507, 16, 49, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[7112, 268, 53, 1, 46, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7202, 274, 494, 15, 52, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[7699, 291, 54, 1, 43, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7790, 297, 544, 17, 52, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[8337, 316, 53, 1, 40, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8427, 322, 499, 15, 52, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[8929, 339, 53, 1, 43, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9019, 345, 434, 13, 51, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[9456, 360, 54, 1, 40, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9547, 366, 176, 5, 42, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[9726, 373, 82, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9857, 381, 49, 0, 30, "Section"],
Cell[9909, 383, 225, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[10159, 391, 319, 7, 38, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[10481, 400, 63, 1, 37, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10581, 406, 303, 7, 60, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[10887, 415, 61, 1, 58, 45, 0, "StyleData", "NumberedFigure", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10985, 421, 291, 7, 62, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[11279, 430, 60, 1, 58, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11388, 437, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[11456, 441, 250, 6, 40, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[11709, 449, 61, 1, 39, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11807, 455, 251, 7, 34, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[12061, 464, 62, 1, 39, 46, 0, "StyleData", "ChemicalFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[12160, 470, 94, 2, 36, 26, 0, "StyleData", "Program", "All"],
Cell[12257, 474, 55, 1, 37, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

